package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.hero.objects.skills.KnowledgeSkill;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class KnowledgeSkillDialog extends SkillDialog {

	private static final long serialVersionUID = 7481786246570656479L;

	JComboBox typeCombo;

	private JLabel typeLbl;

	public KnowledgeSkillDialog(KnowledgeSkill skill, boolean isNew,
			boolean isPower) {
		super(skill, isNew, isPower);
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagLayout layout = (GridBagLayout) panel.getLayout();
		GridBagConstraints gbc2 = layout.getConstraints(displayTF);
		panel.remove(displayTF);
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.weightx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		JPanel inner = new JPanel(new GridBagLayout());
		inner.add(displayTF, gbc);
		gbc.gridx = 1;
		gbc.weightx = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		inner.add(typeLbl, gbc);
		gbc.gridx = 2;
		gbc.weightx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		inner.add(typeCombo, gbc);
		gbc2.weightx = 1;
		panel.add(inner, gbc2);
		return panel;
	}

	@Override
	protected void init() {
		String display = skill.getAlias();
		super.init();
		if (!isNew) {
			skill.setAlias(display);
		} else {
			((KnowledgeSkill) skill)
					.setSelectedTypeByDisplay(((KnowledgeSkill) skill)
							.getSelectedDisplay());
			updateValues();
		}

		updateExamples();
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		typeCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (typeCombo.getSelectedItem() != null) {
					((KnowledgeSkill) skill).setSelectedTypeByDisplay(typeCombo
							.getSelectedItem().toString());
					updateExamples();
					updateValues();
				}
			}
		});
		typeCombo
				.setSelectedItem(((KnowledgeSkill) skill).getSelectedDisplay());
		updateValues();
	}

	@Override
	protected void initWidgets() {
		ArrayList<String> types = new ArrayList<String>();
		if (((KnowledgeSkill) skill).isGroupsAvailable()) {
			types.add(((KnowledgeSkill) skill).getGroupsDisplay());
		}
		if (((KnowledgeSkill) skill).isPeopleAvailable()) {
			types.add(((KnowledgeSkill) skill).getPeopleDisplay());
		}
		if (((KnowledgeSkill) skill).isPlacesAvailable()) {
			types.add(((KnowledgeSkill) skill).getPlacesDisplay());
		}
		if (((KnowledgeSkill) skill).isThingsAvailable()) {
			types.add(((KnowledgeSkill) skill).getThingsDisplay());
		}
		typeCombo = new JComboBox(types.toArray());
		typeLbl = new JLabel("Type:");
		super.initWidgets();
		displayLbl.setText("Display:");
		displayTF.setColumns(6);
	}

	protected void updateExamples() {
		// update the examples...
		exampleCombo.removeItemListener(exampleItemListener);
		String current = object.getInput();
		boolean stockItem = object.getExamples().contains(current);
		exampleCombo.removeAllItems();
		for (int i = 0; i < object.getExamples().size(); i++) {
			exampleCombo.addItem(object.getExamples().get(i));
		}
		if (object.isOtherInputAllowed() && !stockItem) {
			((JTextField) exampleCombo.getEditor().getEditorComponent())
					.setText(current);
		} else {
			exampleCombo.setSelectedItem(current);
		}
		exampleCombo.addItemListener(exampleItemListener);
	}

	@Override
	public void updateValues() {
		if (typeCombo.getSelectedItem() != null) {
			if (typeCombo.getSelectedItem().toString().equals(
					((KnowledgeSkill) skill).getGroupsDisplay())) {
				inputLbl.setText("Knowledge:");
			} else if (typeCombo.getSelectedItem().toString().equals(
					((KnowledgeSkill) skill).getPeopleDisplay())) {
				inputLbl.setText("Culture:");
			} else if (typeCombo.getSelectedItem().toString().equals(
					((KnowledgeSkill) skill).getPlacesDisplay())) {
				inputLbl.setText("Area:");
			} else if (typeCombo.getSelectedItem().toString().equals(
					((KnowledgeSkill) skill).getThingsDisplay())) {
				inputLbl.setText("City:");
			}

		}
		super.updateValues();
	}
}